import random
import numpy as np
import inspect
import poetryrelations
import pickle
from inspect import getmembers, isfunction

functions_list = [o for o in getmembers(poetryrelations) if isfunction(o[1]) if o[0] != "word"]
functions_name_list = [o[0] for o in functions_list if o[0] != "word"]

poems = pickle.load(open("pickles/poems.pcl", "rb"))
poem_vals = {}

poem_vecs = {}
for (poem_ind, poem) in enumerate(poems):
    one_third_poem = len(poem)//3
    poem = poem[one_third_poem:-1*one_third_poem]
    vec = np.zeros((len(poem), 10, len(functions_list)))
    for j in range(len(poem) - 10):
        for k in range(j + 1, j + 9):
            for (ind, (name, f)) in enumerate(functions_list):
                    if f(poem, j, k):
                        if name == "endrhyme":
                            vec[j,k - j, ind] = 5
                        else:
                            vec[j,k - j,ind] = 1
    poem_vals[tuple(poem)] = vec
    if poem_ind % 20 == 19:
        pickle.dump(poem_vals, open("pickles/poem_vecs.pcl", "wb"))
